#!/bin/bash

PATH='/sys/fs/bcache'

if [ ! -d ${PATH} ]; then
  echo "Error: bcache not loaded"
  exit 1
fi

DIRTY_DATA=0
BYPASSED=0

get_dirty_data () {
  for dev in "${PATH}/${1}/bdev*/"; do
    local size=$(<${dev}/dirty_data)
    local bytes=$(/usr/bin/numfmt --from=iec ${size^^})
    DIRTY_DATA=$(( ${DIRTY_DATA} + ${bytes} ))
  done
}

get_hitrate () {
  local hitrate=""
  for dev in "${PATH}/${1}/bdev*/"; do
    local dev_hr=$(<${dev}/stats_${2}/cache_hit_ratio)
    if [ -z ${hitrate} ]; then
      hitrate=${dev_hr}
    fi
    hitrate=$(( (${hitrate} + ${dev_hr}) / 2 ))
  done
  eval HITRATE_${2}=${hitrate}
}

get_requests () {
  for dev in "${PATH}/${1}/bdev*/"; do
    local value=$(<${dev}/stats_five_minute/cache_${2})
    eval REQUEST_${2}=$(( $REQUEST_${2} + ${value} ))
  done
}

get_bypassed () {
  for dev in "${PATH}/${1}/bdev*/"; do
    local size=$(<${dev}/stats_five_minute/bypassed)
    local bytes=$(/usr/bin/numfmt --from=iec ${size^^})
    BYPASSED=$(( ${BYPASSED} + ${bytes} ))
  done
}

for cache in "${PATH}/*/"; do
  uuid=$(/usr/bin/basename ${cache})
  get_bypassed ${uuid}
  get_dirty_data ${uuid}
  get_hitrate ${uuid} total
  get_hitrate ${uuid} day
  get_hitrate ${uuid} hour
  get_hitrate ${uuid} five_minute
  get_requests ${uuid} bypass_hits
  get_requests ${uuid} bypass_misses
  get_requests ${uuid} hits
  get_requests ${uuid} misses
  get_requests ${uuid} miss_collisions
  get_requests ${uuid} readaheads
done

echo "bb:${BYPASSED}\
 dd:${DIRTY_DATA}\
 hr:${HITRATE_total}\
 hr_1d:${HITRATE_day}\
 hr_1h:${HITRATE_hour}\
 hr_5m:${HITRATE_five_minute}\
 req_bh:${REQUEST_bypass_hits}\
 req_bm:${REQUEST_bypass_misses}\
 req_h:${REQUEST_hits}\
 req_m:${REQUEST_misses}\
 req_mc:${REQUEST_miss_collisions}\
 req_ra:${REQUEST_readaheads}"

exit 0