#!/bin/bash

if [ ${#} -ne 1 ]; then
  echo "Usage: $0 <interface>"
  exit 0
fi

INFO=`iwinfo ${1} info`
CHANNEL=`echo "${INFO}" | sed -n 's/.*Channel:\ \(.*\)\ (.*)/\1/p'`
TXPOWER=`echo "${INFO}" | sed -n 's/.*Tx-Power:\ \(.*\)\ dBm.*/\1/p'`
SIGNAL=`echo "${INFO}" | sed -n 's/.*Signal:\ -\(.*\)\ dBm\ \ Noise.*/\1/p'`
NOISE=`echo "${INFO}" | sed -n 's/.*Noise:\ -\(.*\)\ dBm.*/\1/p'`
BITRATE=`echo "${INFO}" | sed -n 's/.*Bit\ Rate:\ \(.*\)\ MBit.*/\1/p'`

echo "channel:${CHANNEL} txpower:${TXPOWER} signal:${SIGNAL} noise:${NOISE} bitrate:${BITRATE}"

exit 0
