#include "esphome.h"
#include "esphome/core/helpers.h"

class Yieryi3178 : public UARTDevice, public PollingComponent {

  public:

    Sensor *ec   = new Sensor();
    Sensor *ph   = new Sensor();
    Sensor *rh   = new Sensor();
    Sensor *temp = new Sensor();
    Sensor *bat  = new Sensor();

    Yieryi3178(UARTComponent *parent, uint32_t update_interval) : UARTDevice(parent), PollingComponent(update_interval) {}

    std::vector<uint8_t> bytes;

    typedef union {
      unsigned char Byte[2];
      uint16_t UInt16;
    } TwoByte;

    void update() override {

      byte request[8] = { 0x01, 0x03, 0x00, 0x00, 0x00, 0x04, 0x44, 0x09 };

      write_array(request, sizeof(request));
      flush();
      delay(10);
      
      while(available() > 0) {

        bytes.push_back(read());      

        if(bytes.size() < 16)
          continue;  

        if(bytes.size() == 16) {

          ESP_LOGV("yieryi3178", "Bytes received: %s", format_hex_pretty(bytes).c_str());

          TwoByte data_ec;
          data_ec.Byte[0] = bytes[5];
          data_ec.Byte[1] = bytes[4];  
          ec->publish_state(data_ec.UInt16 * 0.001);
          ESP_LOGD("yieryi3178", "EC: %.3f", data_ec.UInt16 * 0.001);

          TwoByte data_ph;
          data_ph.Byte[0] = bytes[7];
          data_ph.Byte[1] = bytes[6];  
          ph->publish_state(data_ph.UInt16 * 0.01);
          ESP_LOGD("yieryi3178", "pH: %.2f", data_ph.UInt16 * 0.01);

          TwoByte data_rh;
          data_rh.Byte[0] = bytes[9];
          data_rh.Byte[1] = bytes[8];  
          rh->publish_state(data_rh.UInt16);
          ESP_LOGD("yieryi3178", "RH: %i", data_rh.UInt16);

          TwoByte data_temp;
          data_temp.Byte[0] = bytes[11];
          data_temp.Byte[1] = bytes[10];  
          temp->publish_state(data_temp.UInt16 * 0.1);
          ESP_LOGD("yieryi3178", "Temp: %.1f", data_temp.UInt16 * 0.1);

          TwoByte data_bat;
          data_bat.Byte[0] = bytes[13];
          data_bat.Byte[1] = bytes[12];  
          bat->publish_state(data_bat.UInt16 / 100 / 1.5);
          ESP_LOGD("yieryi3178", "Bat: %.1f", data_bat.UInt16 / 100 / 1.5);

          bytes.clear();

        }
      }
    }
};