#include "esphome.h"
#include "Adafruit_MLX90614.h"

class MLX90614 : public PollingComponent {
  public:

    Adafruit_MLX90614 mlx90614 = Adafruit_MLX90614();
    Sensor *ambient_temperature = new Sensor();
    Sensor *object_temperature = new Sensor();

    MLX90614( uint32_t update_interval ) : PollingComponent(update_interval) {} 

    void setup() override {
      mlx90614.begin();
    }

    void update() override {
      float amb_temperature = 0.0;
      amb_temperature = mlx90614.readAmbientTempC(); // reading twice seemed to eliminate intermittent invalid data reads (shows as 1037.5 C)
      amb_temperature = mlx90614.readAmbientTempC(); 
      ambient_temperature->publish_state(amb_temperature);

      float obj_temperature = 0.0;
      obj_temperature = mlx90614.readObjectTempC(); // only had invalid reads for ambient teperature but taking two readings of object temperature as well fwiw
      obj_temperature = mlx90614.readObjectTempC();
      object_temperature->publish_state(obj_temperature);
    }
};
